import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:viserpay_agent/core/utils/dimensions.dart';
import 'package:viserpay_agent/core/utils/my_strings.dart';
import 'package:viserpay_agent/data/controller/cash_in/cash_in_controller.dart';
import 'package:viserpay_agent/view/components/bottom-sheet/bottom_sheet_close_button.dart';
import 'package:viserpay_agent/view/components/buttons/gradient_rounded_button.dart';
import 'package:viserpay_agent/view/components/divider/custom_divider.dart';
import 'package:viserpay_agent/view/components/row_widget/bottom_sheet_row.dart';
import 'package:viserpay_agent/view/components/text/bottom_sheet_header_text.dart';

class CashInBottomSheet extends StatelessWidget {
  const CashInBottomSheet({super.key});

  @override
  Widget build(BuildContext context) {
    return GetBuilder<CashInController>(
      builder: (controller) => Column(
        crossAxisAlignment: CrossAxisAlignment.start,
        children: [
          const Row(
            mainAxisAlignment: MainAxisAlignment.spaceBetween,
            children: [BottomSheetHeaderText(text: MyStrings.paymentPreview), BottomSheetCloseButton()],
          ),
          const CustomDivider(space: Dimensions.space15),
          BottomSheetRow(
            header: MyStrings.totalAmount,
            body: "${controller.amountController.text} ${controller.currency}",
          ),
          const SizedBox(height: Dimensions.space10),
          BottomSheetRow(
            header: MyStrings.totalCharge,
            body: controller.charge,
          ),
          const SizedBox(height: Dimensions.space10),
          BottomSheetRow(
            header: MyStrings.payable,
            body: controller.payableText,
          ),
          const SizedBox(height: Dimensions.space20),
          GradientRoundedButton(
            showLoadingIcon: controller.submitLoading,
            text: MyStrings.confirm,
            press: () {
              controller.submitCashIn();
            },
          )
        ],
      ),
    );
  }
}
